<?php

session_start();
require __DIR__ . "/../db/database.php";

$user = null;
$bookId = $_GET['bookId'];

// Pārbauda, vai lietotājs ir autorizējies
if (isset($_SESSION["user_id"])) {
    // Iegūst lietotāja id no sessijas
    $user_id = $_SESSION["user_id"];
    
    // Iegūst lietotāja datus no datubāzes
    $sql = sprintf("SELECT * FROM users WHERE id = %d",
        $mysqli->real_escape_string($user_id));

    $result = $mysqli->query($sql);

    // Pārbauda, vai lietotājs ir autorizējies
    if ($result && $result->num_rows > 0) {
        //Ja lietotājs ir autorizējies, iegūst informāciju par lietotāju
        $user = $result->fetch_assoc();

        //Iegūst lietotāja atsauksmi atsauksmi pie konkrētās grāmatas
        $query = "SELECT * FROM reviews WHERE id_book = ? AND id_user = ?";
        $statement = $mysqli->prepare($query);
        $statement->bind_param("ii", $bookId, $user_id);
        $statement->execute();
        $result = $statement->get_result();

        // Pārbauda, vai lietotāja atsauksme eksistē
        if ($result->num_rows > 0) {
            // Ja tā eksistē, iegūst rindas, kur ir lietotajā atsauksmes apraksts un vērtējums
            $row = $result->fetch_assoc();
            $description = $row['description'];
            $score = $row['rating'];
        }

    } else {
        // Gadījumā, ja lietotājs neeksistē, izvada ziņojumu
        echo "Lietotājs nav atrasts!";
        exit; 
    }
}

// Iegūst visas atsauksmes par konkrētu grāmatu
$query = "SELECT * FROM reviews WHERE id_book = ?";
$statement = $mysqli->prepare($query);
$statement->bind_param("i", $bookId);
$statement->execute();
$result = $statement->get_result();

$rows = $result->fetch_all(MYSQLI_ASSOC);

// Nomaina user_id uz lietotājvārdu, un izlabo lietotāja noformēto vērējumu
foreach ($rows as &$row) {
    // Iegūst lietotāja lietotājvārdu
    $query_username = "SELECT username FROM users WHERE id = ?";
    $statement_username = $mysqli->prepare($query_username);
    $statement_username->bind_param("i", $row['id_user']);
    $statement_username->execute();
    $result_username = $statement_username->get_result();
    $username_row = $result_username->fetch_assoc();
    $username = $username_row['username'];

    // Nomaina user_id ar lietotājvārdu
    $row['user_id'] = $username;

    // Izlabo vērtējuma formātu, lai būtu tikai viens skaitlis aiz komata. 
    $rating = $row['rating'];
    if (substr($rating, -2) == '.0') {
         $rating = substr($rating, 0, -2);
    }

    // Nomaina vērtējumu ar izlabotā vērtējuma virkni
    $row['rating'] = $rating;
}

// Iegūst konkrēto grāmatas nosaukumu
$query = "SELECT * FROM books WHERE id = ?";
$statement_title = $mysqli->prepare($query);
$statement_title->bind_param("i", $bookId);
$statement_title->execute();
$result_title = $statement_title->get_result();
$book_title_row = $result_title->fetch_assoc();
$bookTitle = $book_title_row['title'];

?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atsauksmes</title>
    <link rel="stylesheet" href="review.css"> 
</head>

<body>

    <!-- Virsraksta sadaļa, parāda saites atkarībā no lietotāja pieslēguma statusa -->
    <div class="topSection">
        <?php if (isset($_SESSION["user_id"])): ?>
            <a href="../login/logout.php" id="logout">Izrakstīties</a>

        <?php else: ?>
            <a href="../login/login.php" id="login">Autorizēties</a>
            <a href="../register/register.php" id="register">Reģistrēties</a>

        <?php endif; ?>
        <a href="../homepage/homepage.php" id="returnHome">Atpakaļ</a>
    </div>
    
    <!-- Grāmatas virsraksts -->
    <h1><?php echo $bookTitle ?></h1>

    <h1 id="reviewTitle">Atsauksmes</h1>
     
    <!-- Lietotāja ievades lauks un atsauksmes veidošanas forma -->
    <div class="userField">
        <!-- Pārbauda, vai lietotājs ir autorizējies --> 
        <?php if ($user): ?>
            <!-- Ja ir, tad sniedz iespēju pievienot atsauksmi -->
            <form action="reviewform.php" method="post">
                <label for="user"><?php echo $user['username']?></label>
                <br>

                <!-- Teksta ievades lauks atsauksmēm -->
                <textarea name="review" id="review" maxlength="10000"><?php if (isset($description)){echo $description;}?></textarea>
                <br>

                <!-- Vērtējuma ievades lauka diapazons -->
                <span class="rating">
                    <b>Vērtējums: </b>
                    <input id="reviewScore" name="star" type="range" min="0" max="5" value="<?php if (isset($score)){echo $score;} else {echo '0';}?>" step="0.5" />
                    
                    <!-- Zvaigžņu rādītājs, kas lietotājam atļaus izvēlēties vērtējumu veselās zvaigznēs -->
                    <span class="stars" id="stars" onmousemove="updateSlider(event)" onclick="saveScore(event)" onmouseleave="revertScore()">☆☆☆☆☆</span>

                </span>

                <input type="hidden" name="bookid" value="<?php echo $_GET['bookId']?>">

                <span class="submitContainer">
                    <input type="submit" value="Pievienot">
                </span>
                <br>
            </form>
        <?php else: ?>
            <!-- Ja lietotājs nav autorizējies, tiek parādīts paziņojums par nepieciešamību autorizēties -->
            <p>Lai pievienotu atsauksmi, lūdzu piereģistrēties un autorizēties šajai mājaslapai.</p>
        <?php endif; ?>
        <br>
    </div>

    <!-- Kopējais atsauksmju skaits -->
    <h3>Visas atsauksmes(<?php echo count($rows);?>):</h3>

    <!-- Atsauksmju sadaļa, kur tiek izveidotas un parādītas atsauksmes -->
    <div class="userReviews">
        <?php 
        //Cikls, kurš iet, kamēr nav izveidotas visas esošās atsauksmes
        foreach($rows as &$row){
            //Pārbauda, vai apraksts nav tukšs
            if($row['description'] != ""){
                //Ja tas nav tukšs, atsauksme tiek parādīta citiem. 
                echo '<div class="userReviewsContent">';
                echo '<b>';
                echo '<span id="user-review">'. $row['user_id'] .'</span>';
                echo '<span id="rating">Vērtējums: '. $row['rating'] .'/5</span>';
                echo '</b>';
                echo '<p id="user-review-description">'. $row['description'] .'</p>';
                echo '<br>';
                echo '</div>';
            }    
        }
       ?>
    </div>
        
    <script>
        var score = 0;
        <?php if (isset($score)):?>
            var score = <?php echo $score; ?>;
            revertScore();

        <?php endif?>
        // Funkcija, kas atjauno diapazona ievades lauku, kad tiek pārvietots peles kursors
        function updateSlider(event) {
            let label = event.target;
            let slider = document.getElementById('reviewScore');
            let rect = label.getBoundingClientRect();
            let percentage = (event.clientX - rect.left) / rect.width;
            let value = Math.floor(percentage * parseFloat(slider.max))+1;
            slider.value = value;
            let rating = document.getElementById('stars');
            value = (value > 5) ? 5 : value;
            let stars = "";
            for(let i = value; i >=1; i--){
                stars += '★';
            }
            rating.innerText = stars.padEnd(5, '☆');
        }

        // Funkcija, kas saglabā vērtību no diapazona ievades lauka
        function saveScore(event) {
            let label = event.target;
            let slider = document.getElementById('reviewScore');
            score = slider.value;
        }

        // Funkcija, kas atjauno diapazona ievades lauka vērtību uz iepriekšējo vērtību
        function revertScore(e) {
            let label = document.getElementById('stars');
            let slider = document.getElementById('reviewScore');
            slider.value = score
            let rating = document.getElementById('stars');
            value = slider.value
            let stars = "";
            for(let i = value; i >=1; i--){
                stars += '★';
            }
            rating.innerText = stars.padEnd(5, '☆');
        }
    </script>
</body>
</html>
